function CDX = set_zero_RP_COR(CDX)
% --------------------------------------------------------------------------------------------------
% Set the correlation risk premium equal to zero.
% --------------------------------------------------------------------------------------------------
% CDX                       ... credit index structure (see 'all_steps_in_a_row.m')
% --------------------------------------------------------------------------------------------------
% sample call: set_zero_RP_COR(cdx_tv_monthly10)
% --------------------------------------------------------------------------------------------------

for i=1:length(CDX.portfolio)
    cds = CDX.portfolio(i);
    if isempty(cds.bi_P)
        % Do nothing (for now) if no physical default dynamics available
    else
        cds.ai = cds.ai_P .* (cds.bi ./ cds.bi_P);
        if (min(cds.ai) < 0)
            error('Negative factor loading');
        end
        cds.ai = max(0, cds.ai);
    end
    CDX.portfolio(i) = cds;
end